using UnityEngine;
using System.Collections;

public class s_OneShotAnimation : MonoBehaviour
{
	public Texture2D[] mAnimation;	//Sets the animation frames. First one must be still animation.
	public float mAnimationSpeed;	//How fast it goes through the frames. Is / by time, so smaller is faster
	float mTimeToNextFrame = 0;		//Gets set to the animation speed and determines how fast the animation goes.
	int mCurAnimFrame = 0;			//Which animation frame you are on
	
	public void Update()
	{
		mTimeToNextFrame -= Mathf.Abs(Time.deltaTime*s_TimeManager.sRewindSpeed);
		
		//Change current frame; goes up or down depending on if you are rewinding. Only done every couple of frames.
		if (mTimeToNextFrame <= 0)
		{
			++mCurAnimFrame;
			renderer.material.mainTexture = mAnimation[mCurAnimFrame];
			mTimeToNextFrame = mAnimationSpeed;
			
			//Disable it if at the end
			if (mCurAnimFrame == mAnimation.Length-1)
				GetComponent<s_OneShotAnimation>().enabled = false;
		}
	}
}
